% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_thermal_density}
\alias{plot_thermal_density}
\title{Visualize Temperature Distribution (Density Plot)}
\usage{
plot_thermal_density(
  img_obj,
  use_processed = TRUE,
  show_peak = TRUE,
  show_max = TRUE,
  show_min = TRUE,
  digits = 2,
  color = "skyblue",
  point_size = 2,
  point_color = "red",
  point_label_color = "black",
  point_label_size = 2
)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{use_processed}{Logical. If \code{TRUE} (default), uses the 'processed' matrix (masked data).
If \code{FALSE}, uses the 'raw' matrix.}

\item{show_peak}{Logical. If \code{TRUE}, highlights and labels the peak density value (Mode). Default is \code{TRUE}.}

\item{show_max}{Logical. If \code{TRUE}, highlights and labels the maximum temperature value. Default is \code{TRUE}.}

\item{show_min}{Logical. If \code{TRUE}, highlights and labels the minimum temperature value. Default is \code{TRUE}.}

\item{digits}{Integer. Number of decimal places to round the labels to. Default is 2.}

\item{color}{String. Fill color for the density area curve. Default is "skyblue".}

\item{point_size}{Numeric. Size of the points marking Peak/Min/Max. Default is 2.}

\item{point_color}{String. Color of the points marking Peak/Min/Max. Default is "red".}

\item{point_label_color}{String. Color of the text labels. Default is "black".}

\item{point_label_size}{Numeric. Size of the text labels. Default is 2.}
}
\value{
A \code{ggplot} object. Layers can be added subsequently.
}
\description{
Generates a probability density plot of the temperature values within the image.
             This visualization is critical for assessing the homogeneity of the subject's temperature
             and identifying potential artifacts (e.g., bimodal distributions often indicate poor background removal).
}
\details{
The function computes the kernel density estimate of the valid pixels (ignoring NAs).
         It can optionally annotate key statistical landmarks:
         \itemize{
           \item \strong{Peak:} The mode of the distribution (most frequent temperature).
           \item \strong{Max/Min:} The hottest and coldest points in the ROI.
         }
         Text labels are automatically repelled using 'ggrepel' to ensure they do not overlap.
}
\examples{
\donttest{
# Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)

# Apply automated segmentation
img <- roi_segment_ebimage(img, keep_largest = TRUE)

# Density plot
plot_thermal_density(img)
}
}
