% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{bi.dist.gompertz}
\alias{bi.dist.gompertz}
\title{Gompertz Distribution}
\usage{
bi.dist.gompertz(
  concentration,
  rate = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{concentration}{A positive numeric vector, matrix, or array representing the concentration parameter.}

\item{rate}{A positive numeric vector, matrix, or array representing the rate parameter.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A boolean vector, matrix, or array representing an optional mask for observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector representing the shape parameter.}

\item{event}{Integer representing the number of batch dimensions to reinterpret as event dimensions.}

\item{create_obj}{Logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
A BI Gompertz distribution object when \code{sample=FALSE} (for model building).

   A JAX array when \code{sample=TRUE} (for direct sampling).

   A BI distribution object when \code{create_obj=TRUE} (for advanced use cases).
}
\description{
The Gompertz distribution is a distribution with support on the positive real line that is closely
related to the Gumbel distribution. This implementation follows the notation used in the Wikipedia
entry for the Gompertz distribution. See https://en.wikipedia.org/wiki/Gompertz_distribution.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.gompertz(concentration = 5., sample = TRUE)
}
}
\seealso{
This is a wrapper of  \url{https://num.pyro.ai/en/stable/distributions.html#gompertz}
}
