% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-params.R
\name{init_param}
\alias{init_param}
\title{Build an Initial Value List for BayesSIM Models}
\usage{
init_param(
  indexprior,
  link,
  index = NULL,
  index_nu = NULL,
  index_psi = NULL,
  index_pi = NULL,
  link_beta = NULL,
  link_k = NULL,
  link_knots = NULL,
  link_lengthscale = NULL,
  link_amp = NULL,
  link_kappa = NULL,
  link_inv_lambda = NULL,
  sigma2 = NULL
)
}
\arguments{
\item{indexprior}{Character scalar indicating the prior for the index.
Typically one of \code{"fisher"}, \code{"sphere"}, \code{"polar"}, or \code{"spike"}.
The valid options mirror those used in the corresponding model functions.}

\item{link}{Character scalar indicating the link function family.
Typically \code{"bspline"} for B-spline link functions or \code{"gp"} for Gaussian
process link functions. The valid options mirror those used in the
corresponding model functions.}

\item{index, index_nu, index_psi, index_pi}{Optional initial values for index and related parameter values.}

\item{link_beta, link_k, link_knots, link_lengthscale, link_amp, link_kappa, link_inv_lambda}{Optional initial values for components under link functions.}

\item{sigma2}{Optional numeric scalar giving the initial value of \eqn{\sigma^2}.}
}
\value{
A nested list with components \code{index}, \code{link}, and
\code{sigma2}.
}
\description{
\code{init_param} is a convenience helper that constructs a nested initial value list
for a given combination of index vector and link function.
It starts from the model-specific default prior, and then overwrites only those components for
which the user supplies non-\code{NULL} arguments.

This allows users to modify selected hyper-parameters without having to know
or manually reconstruct the full nested prior list structure.
}
\details{
\code{init_param(indexprior, link)} can be used to obtain the random initial values
list for the requested combination of index prior and link function.
For any argument that is not \code{NULL}, the corresponding field in the nested prior list is overwritten.

The detailed meaning and recommended choices for each initial values depend
on the specific model, index vector and link function.
For those details, please refer to the documentation of the corresponding
model-fitting functions.
}
\examples{
## Default initial values for Fisher index + B-spline link:
i0 <- init_param("fisher", "bspline")

## Modify only a few initial values:
i1 <- init_param(
  indexprior = "fisher",
  link       = "bspline",
  index      = c(1, 0, 0),      # initial direction of the index
  link_beta  = rep(0, 21),      # initial values for spline coefficients
  sigma2     = 0.1              # initial value for sigma^2
)

## Example with GP link:
i2 <- init_param(
  indexprior        = "sphere",
  link              = "gp",
  link_lengthscale  = 0.2,      # initial GP length-scale
  link_amp          = 1.5,      # initial GP amplitude
  sigma2            = 1         # initial variance
)

}
\seealso{
\code{\link[=bsFisher]{bsFisher()}}, \code{\link[=bsSphere]{bsSphere()}}, \code{\link[=bsPolar]{bsPolar()}}, \code{\link[=bsSpike]{bsSpike()}},
\code{\link[=gpFisher]{gpFisher()}}, \code{\link[=gpSphere]{gpSphere()}}, \code{\link[=gpPolar]{gpPolar()}}, \code{\link[=gpPolarHigh]{gpPolarHigh()}}, \code{\link[=gpSpike]{gpSpike()}}
}
