% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentData.R
\docType{data}
\name{potter}
\alias{potter}
\title{Fictional pedigree data on a wizarding family}
\format{
A data frame (and ped object) with 36 rows and 10 variables
}
\usage{
data(potter)
}
\description{
A dataset created for educational and illustrative use, containing a fictional pedigree modeled after characters from the Harry Potter series.
This data is structured for use in software demonstrations involving pedigree diagrams, inheritance structures, and kinship modeling.
This dataset is not intended to represent any real individuals or families.
It includes no narrative content or protected expression from the original works and is provided solely for educational purposes.
This dataset is not endorsed by or affiliated with the creators or copyright holders of the Harry Potter series.
}
\details{
The variables are as follows:

\itemize{
  \item \code{personID}:  Person identification variable
  \item \code{famID}: Family identification variable
  \item \code{name}:  Name of the person
  \item \code{first_name}: First name of the person
  \item \code{surname}: Last name of the person
  \item \code{gen}: Generation of the person
  \item \code{momID}:  ID of the mother
  \item \code{dadID}:  ID of the father
  \item \code{spouseID}: ID of the spouse
  \item \code{sex}:  Sex of the ID: 1 is male; 0 is female
  \item \code{twinID}:  ID of the twin, if applicable
  \item \code{zygosity}: Zygosity of the twin, if applicable. mz is monozygotic; dz is dizygotic

}

IDs in the 100s \code{momID}s and \code{dadID}s are for people not in the dataset.
}
\keyword{datasets}
