#' @title Accelerometry Data
#'
#' @description A dataset containing accelerometry data for a single subject in
#' 1-minute epochs, includes vector magnitude and other measurements.
#'
#' \itemize{
#'   \item date: Time and date of a single measurement.
#'   \item axis1: X-axis movement.
#'   \item axis2: Y-axis movement.
#'   \item axis3: Z-axis movement.
#'   \item steps: Steps taken by the subject.
#'   \item lux: Amount of light present, measured in lux.
#'   \item inclineOff: Incline off.
#'   \item inclineStanding: Incline standing.
#'   \item inclineSitting: Incline sitting.
#'   \item inclineLying: Incline lying.
#'   \item VM: Vector magnitude, calculated from x-, y-, and z-axis measurements.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name AccelData
#' @usage data("AccelData")
#' @format A data frame with 1351 rows and 11 variables.
#'
NULL
