/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v30;

import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SeriesCountParser
implements Parser<Map<String, Integer>> {
    private static final String sourceClass = SeriesCountParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String ANNOTATION = "Annotation";
    static final String ANNOTATIONS = "Annotations";
    static final String ID = "id";
    static final String ANNOTATION_TITLE = "AnnotationTitle";
    static final String SERIES_COUNT = "series_count";
    static final String OBS_COUNT = "obs_count";

    @Override
    public Map<String, Integer> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (ANNOTATION.equals(startElement.getName().getLocalPart())) {
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!ID.equals(attribute.getName().getLocalPart()) || !attribute.getValue().equals(SERIES_COUNT) && !attribute.getValue().equals(OBS_COUNT)) continue;
                        string = attribute.getValue();
                    }
                    continue;
                }
                if (!ANNOTATION_TITLE.equals(startElement.getName().getLocalPart()) || string == null) continue;
                hashMap.put(string, Integer.parseInt(xMLEventReader.getElementText()));
                continue;
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(ANNOTATIONS)) continue;
            return hashMap;
        }
        return hashMap;
    }
}

