## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(JapanAPIs)
library(ggplot2)
library(dplyr)

## ----japan-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


japan_gdp <- head(get_japan_gdp())

print(japan_gdp)


## ----japan-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

japan_life_expectancy <- head(get_japan_life_expectancy())

print(japan_life_expectancy)


## ----japan-population,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

japan_population <- head(get_japan_population())

print(japan_population)


## ----japan-vehicles-plot, message=FALSE, warning=FALSE, fig.width=7, fig.height=5----


# Convert time series to a tibble
jpn_vehicle_prod_df <- tibble(
  year = as.numeric(time(jpn_vehicle_prod_ts)),
  production = as.numeric(jpn_vehicle_prod_ts)
)

# Plot the time series
jpn_vehicle_prod_df %>%
  ggplot(aes(x = year, y = production)) +
  geom_line(color = "steelblue", size = 1) +
  labs(
    title = "Japan Vehicle Production (1947–1989)",
    x = "Year",
    y = "Vehicles Produced (in thousands)"
  ) +
  theme_minimal()


