/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateFilteringInformation;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateOrdinaryFilter;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateUpdateInformation;

public class MultivariateOrdinarySmoother {
    private final IMultivariateSsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfMeasurements measurements;
    private final boolean calcvar;
    private final boolean calcsvar;
    private State state;
    private StateStorage srslts;
    private MultivariateFilteringInformation frslts;
    private DoubleSeq err;
    private UpdateInformation.Status[] status;
    private int[] used;
    private DataBlock u;
    private DataBlock s;
    private DataBlock r;
    private FastMatrix M;
    private FastMatrix K;
    private FastMatrix R;
    private FastMatrix N;
    private FastMatrix sV;
    private int stop;

    public static Builder builder(IMultivariateSsf ssf) {
        return new Builder(ssf);
    }

    public MultivariateOrdinarySmoother(IMultivariateSsf ssf, boolean calcvar, boolean calcsvar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.calcsvar = calcsvar;
        this.dynamics = ssf.dynamics();
        this.measurements = ssf.measurements();
    }

    public MultivariateOrdinarySmoother(IMultivariateSsf ssf, boolean calcvar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.calcsvar = calcvar;
        this.dynamics = ssf.dynamics();
        this.measurements = ssf.measurements();
    }

    public boolean process(IMultivariateSsfData data) {
        if (this.ssf.initialization().isDiffuse()) {
            return false;
        }
        MultivariateOrdinaryFilter filter = new MultivariateOrdinaryFilter();
        MultivariateFilteringInformation fresults = new MultivariateFilteringInformation();
        if (!filter.process(this.ssf, data, fresults)) {
            return false;
        }
        return this.process(0, data.getObsCount(), fresults);
    }

    public boolean process(MultivariateFilteringInformation results) {
        if (this.ssf.initialization().isDiffuse()) {
            return false;
        }
        return this.process(0, results.size(), results);
    }

    public boolean process(int start, int end, MultivariateFilteringInformation results) {
        StateStorage sresults = this.calcvar ? StateStorage.full(StateInfo.Smoothed) : StateStorage.light(StateInfo.Smoothed);
        sresults.prepare(this.ssf.getStateDim(), start, end);
        return this.process(start, end, results, sresults);
    }

    public boolean process(int start, int end, MultivariateFilteringInformation results, StateStorage sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.stop = start;
        this.initSmoother(this.ssf);
        int t = end;
        while (--t >= this.stop) {
            this.loadInfo(t);
            if (!this.iterate(t)) continue;
            this.srslts.save(t, this.state, StateInfo.Smoothed);
        }
        return true;
    }

    public StateStorage getSmoothingResults() {
        return this.srslts;
    }

    public MultivariateFilteringInformation getFilteringResults() {
        return this.frslts;
    }

    public DataBlock getFinalR() {
        return this.r;
    }

    public FastMatrix getFinalN() {
        return this.N;
    }

    public DoubleSeq getFinalSmoothation() {
        return this.s;
    }

    public FastMatrix getFinalSmoothationVariance() {
        return this.sV;
    }

    private void initSmoother(IMultivariateSsf ssf) {
        int dim = ssf.getStateDim();
        this.state = new State(dim);
        this.r = DataBlock.make(dim);
        if (this.calcvar) {
            this.N = FastMatrix.square(dim);
        }
    }

    private void loadInfo(int pos) {
        MultivariateUpdateInformation info = this.frslts.get(pos);
        if (info != null) {
            this.err = info.getU();
            this.M = info.getM();
            this.K = this.M.deepClone();
            this.dynamics.TM(pos, this.K);
            this.u = DataBlock.of(info.getU());
            this.R = info.getR();
            this.status = info.getStatus();
            this.used = info.getUsedMeasurements();
        } else {
            this.err = DoubleSeq.empty();
            this.M = FastMatrix.EMPTY;
            this.K = FastMatrix.EMPTY;
            this.u = DataBlock.EMPTY;
            this.R = FastMatrix.EMPTY;
            this.status = null;
            this.used = new int[0];
        }
    }

    private boolean iterate(int pos) {
        this.iterateSmoothation(pos);
        this.iterateR(pos);
        if (this.calcvar) {
            this.iterateN(pos);
        }
        DataBlock fa = this.frslts.a(pos);
        FastMatrix fP = this.frslts.P(pos);
        if (fP == null) {
            return false;
        }
        DataBlock a = this.state.a();
        a.copy(fa);
        a.addProduct(this.r, fP.columnsIterator());
        if (this.calcvar) {
            FastMatrix P = this.state.P();
            P.copy(fP);
            FastMatrix V = SymmetricMatrix.XtSX(this.N, P);
            P.sub(V);
        }
        return true;
    }

    private void iterateSmoothation(int pos) {
        if (this.u.isEmpty()) {
            return;
        }
        this.s = this.u.deepClone();
        this.s.addAProduct(-1.0, this.r, this.K.columnsIterator());
        LowerTriangularMatrix.solvexL(this.R, this.s, 1.0E-9);
        if (this.calcsvar) {
            this.sV = SymmetricMatrix.XtSX(this.N, this.K);
            this.sV.diagonal().add(1.0);
            LowerTriangularMatrix.solveXL(this.R, this.sV, 1.0E-9);
            LowerTriangularMatrix.solveLtX(this.R, this.sV, 1.0E-9);
            SymmetricMatrix.reenforceSymmetry(this.sV);
            this.sV.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
        }
    }

    private void iterateN(int pos) {
        if (!this.R.isEmpty()) {
            int i;
            this.ssf.XL(pos, this.N, this.M, this.R, this.used);
            this.ssf.XtL(pos, this.N, this.M, this.R, this.used);
            for (i = 0; i < this.used.length; ++i) {
                this.measurements.loading(this.used[i]).Z(pos, this.M.column(i));
            }
            LowerTriangularMatrix.solveXLt(this.R, this.M);
            for (i = 0; i < this.used.length; ++i) {
                this.N.addXaXt(1.0, this.M.column(i));
            }
        } else {
            this.dynamics.MT(pos, this.N);
            this.dynamics.TtM(pos, this.N);
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
        this.N.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    private void iterateR(int pos) {
        this.dynamics.XT(pos, this.r);
        if (this.status != null) {
            int j = 0;
            for (int i = 0; i < this.status.length; ++i) {
                if (this.status[i] == UpdateInformation.Status.MISSING) continue;
                double cu = this.s.get(j++);
                this.measurements.loading(i).XpZd(pos, this.r, cu);
            }
        }
        this.r.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    public static class Builder {
        private final IMultivariateSsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;
        private boolean calcSmoothationsVariance = true;

        public Builder(IMultivariateSsf ssf) {
            this.ssf = ssf;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public Builder calcSmoothationsVariance(boolean calc) {
            this.calcSmoothationsVariance = calc;
            return this;
        }

        public MultivariateOrdinarySmoother build() {
            return new MultivariateOrdinarySmoother(this.ssf, this.calcVariance, this.calcSmoothationsVariance);
        }
    }
}

