/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class CompositeLoading
implements ISsfLoading {
    private final ISsfLoading[] loadings;
    private final int[] dim;
    private final DataBlock tmp;

    public CompositeLoading(int[] dim, ISsfLoading[] ms) {
        this.loadings = ms;
        this.dim = dim;
        int n = ms.length;
        int tdim = 0;
        for (int i = 0; i < n; ++i) {
            tdim += dim[i];
        }
        this.tmp = DataBlock.make(tdim);
    }

    @Override
    public boolean isTimeInvariant() {
        for (int i = 0; i < this.loadings.length; ++i) {
            if (this.loadings[i].isTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void Z(int pos, DataBlock z) {
        DataWindow cur = z.left();
        for (int i = 0; i < this.loadings.length; ++i) {
            this.loadings[i].Z(pos, cur.next(this.dim[i]));
        }
    }

    @Override
    public double ZX(int pos, DataBlock m) {
        DataWindow cur = m.window(0, this.dim[0]);
        double x = this.loadings[0].ZX(pos, cur.get());
        for (int i = 1; i < this.loadings.length; ++i) {
            x += this.loadings[i].ZX(pos, cur.next(this.dim[i]));
        }
        return x;
    }

    @Override
    public double ZVZ(int pos, FastMatrix v) {
        MatrixWindow D = v.topLeft(0, 0);
        double x = 0.0;
        for (int i = 0; i < this.loadings.length; ++i) {
            int ni = this.dim[i];
            this.tmp.set(0.0);
            DataWindow wnd = this.tmp.left();
            FastMatrix nD = D.next(ni, ni);
            x += this.loadings[i].ZVZ(pos, nD);
            MatrixWindow C = MatrixWindow.of(nD);
            for (int j = i + 1; j < this.loadings.length; ++j) {
                int nj = this.dim[j];
                DataBlock cur = wnd.next(nj);
                this.loadings[j].ZM(pos, C.vnext(nj), cur);
                x += 2.0 * this.loadings[i].ZX(pos, cur);
            }
        }
        return x;
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        this.tmp.set(0.0);
        this.Z(pos, this.tmp);
        DataBlockIterator cols = V.columnsIterator();
        DoubleSeqCursor.OnMutable cell = this.tmp.cursor();
        while (cols.hasNext()) {
            cols.next().addAY(cell.getAndNext() * d, this.tmp);
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        DataWindow cur = x.left();
        for (int i = 0; i < this.loadings.length; ++i) {
            this.loadings[i].XpZd(pos, cur.next(this.dim[i]), d);
        }
    }
}

