/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.array;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.ElementaryTransformations;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.array.LState;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class ArrayFilter {
    private LState state;
    private UpdateInformation updinfo;
    private ISsfLoading loading;
    private ISsfError error;
    private ISsfDynamics dynamics;
    private boolean missing;
    private int dim;
    private FastMatrix A;

    protected void error(int t, ISsfData data) {
        this.missing = data.isMissing(t);
        if (this.missing) {
            this.updinfo.setMissing();
        } else {
            double y = data.get(t);
            this.updinfo.set(y - this.loading.ZX(t, this.state.a), data.isConstraint(t));
        }
    }

    private void initialize(ISsf ssf) {
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.dim = ssf.getStateDim();
        this.updinfo = new UpdateInformation(this.dim);
        this.state = LState.of(ssf);
        int nres = this.dynamics.getInnovationsDim();
        this.A = FastMatrix.make(this.dim + 1, this.dim + 1 + nres);
        this.L().copy(this.state.L);
    }

    public boolean process(ISsf ssf, ISsfData data, IFilteringResults rslts) {
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.dynamics = ssf.dynamics();
        this.initialize(ssf);
        int t = 0;
        int end = data.length();
        while (t < end) {
            this.error(t, data);
            this.preArray(t);
            ElementaryTransformations.givensTriangularize(this.A);
            this.postArray();
            if (rslts != null) {
                rslts.save(t, this.updinfo);
            }
            this.nextState(t++);
        }
        return true;
    }

    private void preArray(int t) {
        this.loading.ZM(t, this.L(), this.ZL());
        this.dynamics.TM(t, this.L());
        this.U().set(0.0);
        this.dynamics.S(t, this.U());
        this.K().set(0.0);
        if (this.error != null) {
            this.A.set(0, 0, Math.sqrt(this.error.at(t)));
        } else {
            this.A.set(0, 0, 0.0);
        }
    }

    private void postArray() {
        double e = this.A.get(0, 0);
        this.updinfo.setStandardDeviation(e);
        this.updinfo.M().setAY(e, this.K());
    }

    private void nextState(int t) {
        this.dynamics.TX(t, this.state.a);
        if (!this.missing) {
            this.state.a.addAY(this.updinfo.get() / this.updinfo.getVariance(), this.updinfo.M());
        }
    }

    private DataBlock K() {
        return this.A.column(0).drop(1, 0);
    }

    private DataBlock ZL() {
        return this.A.row(0).range(1, 1 + this.dim);
    }

    private FastMatrix L() {
        return this.A.extract(1, this.dim, 1, this.dim);
    }

    private FastMatrix U() {
        return this.A.extract(1, this.dim, 1 + this.dim, this.A.getColumnsCount() - this.dim - 1);
    }
}

