/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl;

import lombok.Generated;

public final class Utility {
    public static final double GSL_DBL_EPSILON = 2.220446049250313E-16;
    public static final double GSL_DBL_MIN = Double.MIN_NORMAL;
    public static final double GSL_DBL_MAX = Double.MAX_VALUE;

    public static double rescale_error(double er, double result_abs, double result_asc) {
        double min_err;
        double err = Math.abs(er);
        if (result_asc != 0.0 && err != 0.0) {
            double scale = Math.pow(200.0 * err / result_asc, 1.5);
            err = scale < 1.0 ? result_asc * scale : result_asc;
        }
        if (result_abs > 2.0041683600089728E-294 && (min_err = (double)1.110223E-14f * result_abs) > err) {
            err = min_err;
        }
        return err;
    }

    public static boolean test_positivity(double result, double resabs) {
        return Math.abs(result) >= 0.9999999999999889 * resabs;
    }

    public static boolean subinterval_too_small(double a1, double a2, double b2) {
        double e = 2.220446049250313E-16;
        double u = Double.MIN_NORMAL;
        double tmp = 1.0000000000000222 * (Math.abs(a2) + 2.2250738585072014E-305);
        return Math.abs(a1) <= tmp && Math.abs(b2) <= tmp;
    }

    @Generated
    private Utility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

