/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.stats;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;

public final class AutoCovariances {
    public static final double SMALL = 1.0E-38;

    public static double[] autoCovariancesWithZeroMean(DoubleSeq data, int maxLag) {
        return AutoCovariances.autoCovariances(data, 0.0, maxLag);
    }

    public static double[] autoCovariances(DoubleSeq data, double mean, int maxLag) {
        double[] autoCovariance = new double[maxLag + 1];
        if (data.anyMatch(x -> !Double.isFinite(x))) {
            autoCovariance[0] = AutoCovariances.variance(data, mean);
            for (int i = 1; i <= maxLag; ++i) {
                autoCovariance[i] = AutoCovariances.autoCovariance(data, mean, i);
            }
        } else {
            autoCovariance[0] = AutoCovariances.varianceNoMissing(data, mean);
            for (int i = 1; i <= maxLag; ++i) {
                autoCovariance[i] = AutoCovariances.autoCovarianceNoMissing(data, mean, i);
            }
        }
        return autoCovariance;
    }

    public static double covarianceWithZeroMean(DoubleSeq x, DoubleSeq y, int t) {
        if (t < 0) {
            return AutoCovariances.covarianceWithZeroMean(y, x, -t);
        }
        double v = 0.0;
        int n = x.length() - t;
        int nm = 0;
        DoubleSeqCursor xr = x.cursor();
        DoubleSeqCursor yr = y.cursor();
        yr.moveTo(t);
        for (int i = 0; i < n; ++i) {
            double xcur = xr.getAndNext();
            double ycur = yr.getAndNext();
            if (Double.isFinite(xcur) && Double.isFinite(ycur)) {
                v += xcur * ycur;
                continue;
            }
            ++nm;
        }
        int m = x.length() - nm;
        if (m == 0) {
            return 0.0;
        }
        return v / (double)m;
    }

    public static double covarianceWithZeroMean(DoubleSeq x, DoubleSeq y) {
        return AutoCovariances.covarianceWithZeroMean(x, y, 0);
    }

    public static double covarianceWithZeroMeanAndNoMissing(DoubleSeq x, DoubleSeq y, int t) {
        if (t < 0) {
            return AutoCovariances.covarianceWithZeroMeanAndNoMissing(y, x, -t);
        }
        double v = 0.0;
        int n = x.length() - t;
        DoubleSeqCursor xr = x.cursor();
        DoubleSeqCursor yr = y.cursor();
        yr.moveTo(t);
        for (int i = 0; i < n; ++i) {
            v += xr.getAndNext() * yr.getAndNext();
        }
        return v / (double)x.length();
    }

    public static IntToDoubleFunction autoCorrelationFunction(DoubleSeq data, double mean) {
        if (data.anyMatch(x -> !Double.isFinite(x))) {
            double var = AutoCovariances.variance(data, mean);
            return i -> var < 1.0E-38 ? 0.0 : AutoCovariances.autoCovariance(data, mean, i) / var;
        }
        double var = AutoCovariances.varianceNoMissing(data, mean);
        return i -> var < 1.0E-38 ? 0.0 : AutoCovariances.autoCovarianceNoMissing(data, mean, i) / var;
    }

    public static IntToDoubleFunction autoCovarianceFunction(DoubleSeq data, double mean) {
        if (data.anyMatch(x -> !Double.isFinite(x))) {
            return i -> AutoCovariances.autoCovariance(data, mean, i);
        }
        return i -> AutoCovariances.autoCovarianceNoMissing(data, mean, i);
    }

    public static double autoCovarianceNoMissing(DoubleSeq data, double mean, int lag) {
        int n = data.length() - lag;
        if (n <= 0) {
            return 0.0;
        }
        double v = 0.0;
        DoubleSeqCursor xr = data.cursor();
        DoubleSeqCursor yr = data.cursor();
        yr.moveTo(lag);
        for (int j = 0; j < n; ++j) {
            double xcur = xr.getAndNext();
            double ycur = yr.getAndNext();
            v += (xcur - mean) * (ycur - mean);
        }
        return v / (double)data.length();
    }

    public static double varianceNoMissing(DoubleSeq data, double mean) {
        int n = data.length();
        if (n == 0) {
            return 0.0;
        }
        double v = 0.0;
        DoubleSeqCursor xr = data.cursor();
        for (int j = 0; j < n; ++j) {
            double xcur = xr.getAndNext();
            v += (xcur - mean) * (xcur - mean);
        }
        return v / (double)n;
    }

    public static double variance(DoubleSeq data, double mean) {
        double v = 0.0;
        int n = data.length();
        int nm = 0;
        DoubleSeqCursor xr = data.cursor();
        for (int j = 0; j < n; ++j) {
            double xcur = xr.getAndNext();
            if (Double.isFinite(xcur)) {
                v += (xcur - mean) * (xcur - mean);
                continue;
            }
            ++nm;
        }
        int m = data.length() - nm;
        if (m == 0) {
            return 0.0;
        }
        return v / (double)m;
    }

    public static double autoCovariance(DoubleSeq data, double mean, int lag) {
        double v = 0.0;
        int n = data.length() - lag;
        int nm = 0;
        DoubleSeqCursor xr = data.cursor();
        DoubleSeqCursor yr = data.cursor();
        yr.moveTo(lag);
        for (int j = 0; j < n; ++j) {
            double xcur = xr.getAndNext();
            double ycur = yr.getAndNext();
            if (Double.isFinite(xcur) && Double.isFinite(ycur)) {
                v += (xcur - mean) * (ycur - mean);
                continue;
            }
            ++nm;
        }
        int m = data.length() - nm;
        if (m == 0) {
            return 0.0;
        }
        return v / (double)m;
    }

    public static double[] partialAutoCorrelations(IntToDoubleFunction acfn, int kmax) {
        double[] pac = new double[kmax];
        double[] tmp = new double[kmax];
        double[] coeff = new double[kmax];
        double[] ac = new double[kmax];
        for (int i = 0; i < kmax; ++i) {
            ac[i] = acfn.applyAsDouble(i + 1);
        }
        pac[0] = coeff[0] = ac[0];
        for (int K = 2; K <= kmax; ++K) {
            double n = 0.0;
            double d = 0.0;
            for (int k = 1; k <= K - 1; ++k) {
                double x = coeff[k - 1];
                n += ac[K - k - 1] * x;
                d += ac[k - 1] * x;
            }
            double d2 = (ac[K - 1] - n) / (1.0 - d);
            coeff[K - 1] = d2;
            pac[K - 1] = d2;
            for (int i = 0; i < K; ++i) {
                tmp[i] = coeff[i];
            }
            for (int j = 1; j <= K - 1; ++j) {
                coeff[j - 1] = tmp[j - 1] - tmp[K - 1] * tmp[K - j - 1];
            }
        }
        return pac;
    }

    @Generated
    private AutoCovariances() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

