/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.arima;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.advanced.arima.Arima;

public final class ArimaLoader {

    public static final class Processor {
        private final Iterable<Arima.Processor> source = ServiceLoader.load(Arima.Processor.class);
        private final AtomicReference<Arima.Processor> resource = new AtomicReference<Arima.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Arima.Processor doLoad() throws IllegalStateException {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("Missing mandatory provider of Arima.Processor"));
        }

        public Arima.Processor get() {
            return this.resource.get();
        }

        public void set(Arima.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Iterable<Arima.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IllegalStateException {
            Iterable<Arima.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

