## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(checkmate)
library(checkCLI)

## ----error=TRUE---------------------------------------------------------------
try({
assert_int(3.14)
})

## ----error=TRUE---------------------------------------------------------------
try({
assert_int_cli(3.14)
})

## ----error=TRUE---------------------------------------------------------------
try({
# This will produce a formatted error message
assert_numeric_cli(c("a", "b"))
})

## ----error=TRUE---------------------------------------------------------------
try({
# Create an assertion collection
add <- AssertCollection$new()

# Run multiple assertions
assert_numeric_cli(c("a", "b"), add = add)
assert_int_cli(3.14, add = add)
assert_file_exists_cli("nonexistent.txt", add = add)

# Report all errors at once
if (!add$isEmpty()) {
  add$report()
}
})

## ----error=TRUE---------------------------------------------------------------
try({
# Assert that at least one condition is true ("or")
assert_cli(
  check_numeric_cli(x),
  check_integer_cli(x),
  combine = "or"
)

# Assert that all conditions are true ("and")
assert_cli(
  check_numeric_cli(x),
  check_vector_cli(x),
  combine = "and"
)
})

## ----error=TRUE---------------------------------------------------------------
try({
# Specify a custom variable name in error messages
my_data <- "invalid"
assert_numeric_cli(my_data, .var.name = "my_data")
})

