/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.x13.base.core.x11.filter.IFiltering;
import jdplus.x13.base.core.x11.filter.X11SeasonalFiltersFactory;

public class X11SeasonalFilterProcessor {
    private final IFiltering[] filters;

    public X11SeasonalFilterProcessor(IFiltering[] filters) {
        this.filters = filters;
    }

    public DoubleSeq process(DoubleSeq input, int start) {
        double[] x = new double[input.length()];
        int period = this.filters.length;
        int ny_all = input.length() / period;
        int nyr_all = input.length() % period == 0 ? ny_all : ny_all + 1;
        DataBlock out = DataBlock.of((double[])x);
        DataBlock in = DataBlock.of((DoubleSeq)input);
        for (int i = 0; i < period; ++i) {
            DataBlock ccout;
            int index = (start + i) % period;
            DataBlock cin = in.extract(i, -1, period);
            DataBlock cout = out.extract(i, -1, period);
            int nf = 0;
            IFiltering iFiltering = this.filters[index];
            if (iFiltering instanceof X11SeasonalFiltersFactory.DefaultFilter) {
                X11SeasonalFiltersFactory.DefaultFilter defaultFilter = (X11SeasonalFiltersFactory.DefaultFilter)iFiltering;
                nf = defaultFilter.getSfilter().getUpperBound();
            }
            if (ny_all >= 5 && (nf < 8 || nyr_all >= 20)) {
                ccout = this.filters[index].process(cin);
            } else {
                X11SeasonalFiltersFactory.StableFilter stable = new X11SeasonalFiltersFactory.StableFilter(period);
                ccout = stable.process(cin);
            }
            cout.set(ccout, y -> y);
        }
        return DoubleSeq.of((double[])x);
    }
}

