/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import java.util.ArrayList;
import java.util.Arrays;

public class BindingStack
implements BindingEnvironment {
    protected Node[] environment;
    protected ArrayList trail = new ArrayList();
    protected int index = 0;
    protected int highWater = 0;
    protected static final int MAX_VAR = 10;

    public BindingStack() {
        this.trail.add(new Node[10]);
        this.environment = (Node[])this.trail.get(0);
        this.highWater = 0;
        this.index = 0;
    }

    public void push() {
        if (this.index == this.highWater) {
            this.trail.add(new Node[10]);
            ++this.highWater;
        }
        Node[] newenv = (Node[])this.trail.get(++this.index);
        System.arraycopy(this.environment, 0, newenv, 0, 10);
        this.environment = newenv;
    }

    public void unwind() throws IndexOutOfBoundsException {
        if (this.index <= 0) {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
        this.environment = (Node[])this.trail.get(--this.index);
    }

    public void commit() throws IndexOutOfBoundsException {
        if (this.index > 0) {
            Node[] newenv = (Node[])this.trail.get(this.index - 1);
            this.trail.set(this.index - 1, this.environment);
            this.trail.set(this.index, newenv);
            --this.index;
        } else {
            throw new IndexOutOfBoundsException("Underflow of BindingEnvironment");
        }
    }

    public void reset() {
        this.index = 0;
        this.environment = (Node[])this.trail.get(0);
        Arrays.fill(this.environment, null);
    }

    public Node[] getEnvironment() {
        return this.environment;
    }

    public Node getBinding(Node node) {
        if (node instanceof Node_RuleVariable) {
            return this.environment[((Node_RuleVariable)node).getIndex()];
        }
        if (node instanceof Node_ANY) {
            return null;
        }
        if (Functor.isFunctor(node)) {
            Functor functor = (Functor)node.getLiteralValue();
            if (functor.isGround()) {
                return node;
            }
            Node[] args = functor.getArgs();
            ArrayList<Node> boundargs = new ArrayList<Node>(args.length);
            for (int i = 0; i < args.length; ++i) {
                Node binding = this.getBinding(args[i]);
                if (binding == null) {
                    return null;
                }
                boundargs.add(binding);
            }
            Functor newf = new Functor(functor.getName(), boundargs);
            return Functor.makeFunctorNode(newf);
        }
        return node;
    }

    public Node getGroundVersion(Node node) {
        Node bind = this.getBinding(node);
        if (bind == null) {
            return node;
        }
        return bind;
    }

    public boolean bind(int i, Node value) {
        Node node = this.environment[i];
        if (node == null) {
            this.environment[i] = value;
            return true;
        }
        return node.sameValueAs(value);
    }

    public boolean bind(Node var, Node value) {
        if (var instanceof Node_RuleVariable) {
            return this.bind(((Node_RuleVariable)var).getIndex(), value);
        }
        return var.sameValueAs(value);
    }

    public void bindNoCheck(Node_RuleVariable var, Node value) {
        this.environment[var.getIndex()] = value;
    }

    public Triple instantiate(TriplePattern pattern) {
        Node o;
        Node p;
        Node s = this.getGroundVersion(pattern.getSubject());
        if (s.isVariable()) {
            s = Node.createAnon();
        }
        if ((p = this.getGroundVersion(pattern.getPredicate())).isVariable()) {
            p = Node.createAnon();
        }
        if ((o = this.getGroundVersion(pattern.getObject())).isVariable()) {
            o = Node.createAnon();
        }
        return new Triple(s, p, o);
    }
}

