
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "blocking command-line interface to inotify",
  "AUTHOR" => "\303\206var Arnfj\303\266r\303\260 Bjarmason <avar\@cpan.org>",
  "BUILD_REQUIRES" => {
    "File::Find" => 0,
    "File::Temp" => 0,
    "Test::More" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "App-Inotify-Hookable",
  "EXE_FILES" => [
    "bin/inotify-hookable"
  ],
  "LICENSE" => "perl",
  "NAME" => "App::Inotify::Hookable",
  "PREREQ_PM" => {
    "Class::Inspector" => 0,
    "Data::BitMask" => 0,
    "Data::Dumper" => 0,
    "File::Find::Rule" => 0,
    "Linux::Inotify2" => 0,
    "List::MoreUtils" => 0,
    "Moose" => 0,
    "MooseX::Getopt::Dashes" => 0,
    "MooseX::Types::Moose" => 0,
    "POSIX" => 0,
    "Time::HiRes" => 0,
    "Try::Tiny" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "VERSION" => "0.06",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



