      PROGRAM XFIT
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  EXAMPLE PROGRAM FOR REGIONAL FREQUENCY ANALYSIS USING THE METHOD OF
C  L-MOMENTS. THE PROGRAM FITS A DISTRIBUTION TO REGIONAL DATA AND USES
C  IT TO ESTIMATE QUANTILES AT EACH SITE.
C
C  THIS EXAMPLE FITS A WAKEBY DISTRIBUTION, USING A VARIANT (PLOTTING
C  POSITION ESTIMATORS INSTEAD OF UNBIASED) OF THE REGIONAL L-MOMENT
C  ALGORITHM DESCRIBED BY HOSKING AND WALLIS ("REGIONAL FREQUENCY
C  ANALYSIS: AN APPROACH BASED ON L-MOMENTS", CAMBRIDGE UNIV. PRESS,
C  1997).  TO FIT A DIFFERENT DISTRIBUTION, REPLACE THE CALLS TO
C  SUBROUTINES PELWAK AND QUAWAK BY THE APPROPRIATE PEL... AND QUA...
C  ROUTINES, CHANGE THE 'WAKEBY' IN FORMAT STATEMENT 6030 AND CHANGE
C  THE VALUE OF PARAMETER NPAR.
C
C  PARAMETERS OF PROGRAM:
C  MAXNS  - SHOULD BE AT LEAST AS LARGE AS THE NUMBER OF SITES IN THE
C           REGION
C  MAXN   - SHOULD BE AT LEAST AS LARGE AS THE LARGEST RECORD LENGTH
C           AT ANY SITE IN THE REGION
C  NPAR   - NUMBER OF PARAMETERS IN THE DISTRIBUTION TO BE FITTED
C           (5 FOR WAKEBY, OF COURSE)
C  NPROB  - NUMBER OF FLOOD QUANTILES TO BE ESTIMATED AT EACH SITE
C  INFILE - STREAM NUMBER TO WHICH INPUT FILE IS ATTACHED
C
C  ARRAYS TO BE INITIALIZED IN DATA STATEMENTS:
C  PROB(NPROB) - PROBABILITIES FOR WHICH QUANTILES ARE TO BE ESTIMATED
C
C  VARIABLES TO BE INITIALIZED IN DATA STATEMENTS:
C  A      - ) PARAMETERS OF
C  B      - ) PLOTTING POSITION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXNS=100,MAXN=200,NPAR=5,NPROB=10,INFILE=7)
      CHARACTER*32 SITEID
      DOUBLE PRECISION PROB(NPROB),QUANT(NPROB),PARA(5),RMOM(5),
     *  RQUANT(NPROB),WEIGHT(MAXNS),X(MAXN),XMOM(5,MAXNS)
C
      DATA PROB/0.1D0,0.2D0,0.5D0,0.8D0,0.9D0,0.95D0,0.98D0,0.99D0,
     *  0.999D0,0.9999D0/
      DATA A,B/-0.35D0,0D0/
C
      IF(A.EQ.0D0.AND.B.EQ.0D0)WRITE(6,6000)
      IF(A.NE.0D0.OR.B.NE.0D0)WRITE(6,6010)A,B
C
C         READ THE DATA AND CALCULATE AT-SITE L-MOMENTS.
C         ASSUMED STRUCTURE OF DATA FILE IS AS FOLLOWS.
C         1. ONE RECORD CONTAINING THE NUMBER OF SITES IN THE REGION.
C         2. FOR EACH SITE:
C            A  ONE RECORD CONTAINING AN IDENTIFYING LABEL FOR THE SITE;
C            B. ONE RECORD CONTAINING THE RECORD LENGTH AT THE SITE;
C            C. THE DATA VALUES, IN FREE FORMAT.
C
      READ(INFILE,*)NSITE
      DO 10 ISITE=1,NSITE
      READ(INFILE,'(A32)')SITEID
      READ(INFILE,*)N
      READ(INFILE,*)(X(I),I=1,N)
      WEIGHT(ISITE)=N
      CALL SORT(X,N)
      CALL SAMLMR(X,N,XMOM(1,ISITE),NPAR,A,B)
      WRITE(6,6020)ISITE,SITEID,N,(XMOM(I,ISITE),I=1,NPAR)
   10 CONTINUE
C
C         CALCULATE REGIONAL AVERAGE L-MOMENTS
C
      CALL REGLMR(NSITE,NPAR,5,XMOM,WEIGHT,RMOM)
      WRITE(6,6030)(RMOM(I),I=1,NPAR)
C
C         FIT REGIONAL FREQUENCY DISTRIBUTION
C
      CALL PELWAK(RMOM,PARA,IFAIL)
      IF(IFAIL.NE.0)WRITE(6,6040)IFAIL
      WRITE(6,6050)(PARA(I),I=1,NPAR)
C
C         CALCULATE QUANTILES OF REGIONAL FREQUENCY DISTRIBUTION
C
      WRITE(6,6060)(PROB(IQ),IQ=1,NPROB)
      DO 20 IQ=1,NPROB
   20 RQUANT(IQ)=QUAWAK(PROB(IQ),PARA)
      WRITE(6,6070)(RQUANT(IQ),IQ=1,NPROB)
C
C         CALCULATE QUANTILE ESTIMATES FOR EACH SITE
C
      DO 40 ISITE=1,NSITE
      DO 30 IQ=1,NPROB
   30 QUANT(IQ)=XMOM(1,ISITE)*RQUANT(IQ)
      WRITE(6,6080)ISITE,(QUANT(IQ),IQ=1,NPROB)
   40 CONTINUE
C
      STOP
C
 6000 FORMAT(' REGIONAL ANALYSIS, UNBIASED L-MOMENTS'/)
 6010 FORMAT(' REGIONAL ANALYSIS,',
     *  ' L-MOMENT PLOTTING POSITION PARAMETERS ',2F8.4/)
 6020 FORMAT(' SITE',I3,1X,A32,'N=',I3,'   L-MOMENT RATIOS', F9.2,4F9.4)
 6030 FORMAT(//' REGIONAL AVERAGE L-MOMENT RATIOS',5F9.4)
 6040 FORMAT(/' PARAMETER ESTIMATION: FAIL FLAG',I2)
 6050 FORMAT(/' REGIONAL WAKEBY PARAMETERS',5F12.4)
 6060 FORMAT(///'  SITE',25X,'QUANTILES'/' NUMBER',10F10.4/1X,106('-'))
 6070 FORMAT(' REGION',10F10.2/)
 6080 FORMAT(1X,I4,2X,10F10.2)
      END
