#include "tommath_private.h"
#ifdef MP_CLAMP_C
/* LibTomMath, multiple-precision integer library -- Tom St Denis */
/* SPDX-License-Identifier: Unlicense */

/* trim unused digits
 *
 * This is used to ensure that leading zero digits are
 * trimmed and the leading "used" digit will be non-zero
 * Typically very fast.  Also fixes the sign if there
 * are no more leading digits
 */
void mp_clamp(mp_int *a)
{
   /* decrease used while the most significant digit is
    * zero.
    */
   while ((a->used > 0) && (a->dp[a->used - 1] == 0u)) {
      --(a->used);
   }

   /* reset the sign flag if zero */
   if (mp_iszero(a)) {
      a->sign = MP_ZPOS;
   }
}
#endif
