package WebService::MinFraud::Role::Record::HasRisk;

use Moo::Role;

our $VERSION = '1.001000';

use Types::Standard qw( Num );

has risk => (
    is        => 'ro',
    isa       => Num,
    predicate => 1,
);

1;

# ABSTRACT: A role to add a risk attribute

__END__

=pod

=head1 NAME

WebService::MinFraud::Role::Record::HasRisk - A role to add a risk attribute

=head1 VERSION

version 1.001000

=head1 AUTHOR

Mateu Hunter <mhunter@maxmind.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 - 2016 by MaxMind, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
