
#
# Copyright (C) 2003  Sam Horrocks
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package PersistentMake::mod_persistentperl;

use strict;
use ExtUtils::MakeMaker;
use vars qw(@ISA);

require '../src/PersistentMake.pl';
@ISA = 'PersistentMake';

sub inc {'apache'}
sub main_file_full {'mod_persistentperl'}
sub my_name_full {shift->main_file_full}
sub mod_persistentperl_out {'mod_persistentperl.so'}
sub mod_persistentperl_target {'mod_persistentperl.so'}
sub clean_files_extra {}
sub mod_persistentperl_cmds {'../src/mod_persistentperl_cmds.c'}
sub debug_opts {
    return shift->devel ? "'-Wc,${PersistentMake::OPTIMIZE}'" : undef;
}

sub write_makefile { my $class = shift;
    printf "Writing Makefile for %s\n", $class->my_name_full;
    $class->make_perperl_h;
    my $mm = MM->new({$class->mm_params});

    open(F, '>Makefile');

    foreach my $x (
	[qw(SRC_CFILES src_files_c)],
	[qw(OFILES src_files_o)],
	[qw(C_FILE_CLEAN clean_files_c)],
	[qw(CHECK_SYMS check_syms_def)],
	[qw(DEF extra_defines)],
	[qw(DEBUG debug_opts)],
	[qw(SHARED_OBJ_TARGET mod_persistentperl_target)],
	[qw(SHARED_OBJ_REAL mod_persistentperl_out)],
	[qw(CLEAN_EXTRA clean_files_extra)],
	[qw(MOD_PERSISTENTPERL_CMDS mod_persistentperl_cmds)],
    )
    {
	my($def, $method) = @$x;
	printf F "${def}=%s\n\n", join(' ', $class->$method());
    }

    while (my($key,$val) = each %{$PersistentMake::write_makefile_common{macro}}) {
	print F "${key} = $val\n";
    }

    print F join("\n\n",
	"##\n## Generated by Makefile.PL\n##",
	$mm->constants,
	$mm->tools_other,
	'all: mod_persistentperl.so',
	$class->symlink_c_files,
	$class->optdefs_cmds,
	$mm->test,
	$class->testing_postamble,
	''
    );

    if ($class->mod_persistentperl_out ne 'mod_persistentperl.so') {
	printf F "\nmod_persistentperl.so: %s\n\t\$(CP) %s mod_persistentperl.so\n\n",
	    $class->mod_persistentperl_target, $class->mod_persistentperl_out;
    }

    open(F2, '../mod_persistentperl/Makefile.tmpl');
    print F <F2>;
    close(F2);

    close(F);
}

$main::do_not_write_makefile || PersistentMake::mod_persistentperl->init->write_makefile;
