package Sah::SchemaR::idx::listed_stock_code;

our $DATE = '2021-01-18'; # DATE
our $VERSION = '0.001'; # VERSION

our $rschema = ["str",[{description=>"\nCode must be listed.\n\nWill be normalized to code in uppercase.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>"BBRI",value=>"BBRI"},{valid=>1,validated_value=>"BBRI",value=>"bbri"},{summary=>"Too long",valid=>0,value=>"BANKBRI"},{summary=>"Not currently listed",valid=>0,value=>"KARK"}],len=>4,match=>qr(\A[A-Z]{4}\z),prefilters=>["Finance::SE::IDX::check_stock_code_listed"],summary=>"Currently listed stock code in the Indonesian Stock Exchange","x.completion"=>"idx_listed_stock_code"}],["str"]];

1;
# ABSTRACT: Currently listed stock code in the Indonesian Stock Exchange

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::idx::listed_stock_code - Currently listed stock code in the Indonesian Stock Exchange

=head1 VERSION

This document describes version 0.001 of Sah::SchemaR::idx::listed_stock_code (from Perl distribution Sah-Schemas-Finance-SE-IDX), released on 2021-01-18.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Finance-SE-IDX>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Finance-SE-IDX>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Sah-Schemas-Finance-SE-IDX/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
