
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Collect and report caller (test file) and\ncovered (source file) statistics from the cover_db",
  "AUTHOR" => "Johan Lindstrom <johanl\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Test::Differences" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0,
    "warnings" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Devel-CoverX-Covered",
  "EXE_FILES" => [
    "bin/covered"
  ],
  "LICENSE" => "perl",
  "NAME" => "Devel::CoverX::Covered",
  "PREREQ_PM" => {
    "DBD::SQLite" => 0,
    "DBIx::Simple" => 0,
    "Data::Dumper" => 0,
    "Devel::Cover::DB" => 0,
    "File::Basename" => 0,
    "File::Path" => 0,
    "File::chdir" => 0,
    "Getopt::Long" => 0,
    "Memoize" => 0,
    "Moose" => 0,
    "POSIX" => 0,
    "Path::Class" => 0,
    "Pod::Usage" => 0,
    "strict" => 0
  },
  "VERSION" => "0.012",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



