package Net::Async::Spotify::Object::Generated::ResumePoint;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::ResumePoint - Package representing Spotify ResumePoint Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify ResumePoint Object attributes:

=over 4

=item fully_played

Type:Boolean
Description:Whether or not the episode has been fully played by the user.

=item resume_position_ms

Type:Integer
Description:The user’s most recent position in the episode in milliseconds.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        fully_played => 'Boolean',
        resume_position_ms => 'Integer',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
