package Net::Async::Spotify::Object::Generated::Copyright;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Copyright - Package representing Spotify Copyright Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Copyright Object attributes:

=over 4

=item text

Type:String
Description:The copyright text for this content.

=item type

Type:String
Description:The type of copyright: C = the copyright, P = the sound recording (performance) copyright.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        text => 'String',
        type => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
