package Locales::DB::Territory::my;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::my::VERSION = '0.09';

$Locales::DB::Territory::my::cldr_version = '2.0';

%Locales::DB::Territory::my::code_to_name = (
    '001' => 'ကမ္ဘာ',
    '002' => 'အာဖရိက',
    '003' => "မြောက်\ အမေရိက",
    '005' => "တောင်\ အမေရိက",
    '009' => 'သမုဒ္ဒရာဒေသ',
    '011' => "အနောက်\ အာဖရိက",
    '013' => "အလယ်ပိုင်း\ အမေရိက",
    '014' => "အရှေ့ပိုင်း\ အာဖရိက",
    '015' => "မြောက်ပိုင်း\ အာဖရိက",
    '017' => "အလယ်ပိုင်း\ အာဖရိက",
    '018' => "တောင်ပိုင်း\ အာဖရိက",
    '019' => 'အမေရိကများ',
    '021' => "မြောက်ပိုင်း\ အမေရိက",
    '029' => 'ကာရီဘီယံ',
    '030' => "အရှေ့ပိုင်း\ အာရှ",
    '034' => "တောင်ပိုင်း\ အာရှ",
    '035' => "အ‌ရှေ့တောင်ပိုင်း\ အာရှ",
    '039' => "တောင်ပိုင်း\ ဥရောပ",
    '053' => "ဩစတြေးလျှ\ နှင့်\ နယူးဇီလန်",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "တောင်\-အလယ်\ အာရှ",
    142   => 'အာရှ',
    143   => "အလယ်\ အာရှ",
    145   => "အနောက်\ အာရှ",
    150   => 'ဥရောပ',
    151   => "အရှေ့ပိုင်း\ ဥရောပ",
    154   => "မြောက်ပိုင်း\ ဥရောပ",
    155   => "အနောက်ပိုင်း\ ဥရောပ",
    172   => "လွတ်လပ်သော\ ပြည်ထောင်စုများ၏\ ဓနသဟာယအဖွဲ့",
    200   => 'Czechoslovakia',
    419   => "လက်တင်\ အမေရိက\ နှင့်\ ကာရီဘီယန်",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andorra',
    'ae'  => 'ယူအေအီး',
    'af'  => 'အာဖဂန်နစ္စတန်',
    'ag'  => "Antigua\ and\ Barbuda",
    'ai'  => 'အန်ကွီလာ',
    'al'  => 'Albania',
    'am'  => 'အာမေနီးယား',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'အင်ဂိုလာ',
    'aq'  => 'အန္တာတိက',
    'ar'  => 'အာဂျင်တီးနား',
    'as'  => "အမေရိကန်\ စမိုအ",
    'at'  => 'ဩစတြီးယား',
    'au'  => 'ဩစတြေးလျှား',
    'aw'  => 'Aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'အဇာဘိုင်ဂျန်',
    'ba'  => "ဘော့စနီးယား\ နှင့်\ ဟာဇီဂိုဘီးနား",
    'bb'  => 'Barbados',
    'bd'  => 'ဘင်္ဂလားဒေ့ရှ်',
    'be'  => 'ဘယ်လ်ဂျီယမ်',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'ဘူဂေးရီးယား',
    'bh'  => 'ဘာရိန်း',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'ဘာမူဒါ',
    'bn'  => 'ဘရူနိုင်း',
    'bo'  => 'ဘိုလီးဘီးယား',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'ဘရာဇီး',
    'bs'  => 'ဘဟားမား',
    'bt'  => 'ဘူတန်',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'ဘော့စ်ဝါနာ',
    'by'  => 'ဘီလာရုစ်',
    'bz'  => 'ဘေလီဇ်',
    'ca'  => 'ကနေဒါ',
    'cc'  => "ကိုကိုး\ ကျွန်းစု",
    'cd'  => "Congo\ \[DRC\]",
    'cf'  => "အလယ်ပိုင်း\ အာဖရိက\ ပြည်ထောင်စု",
    'cg'  => "Congo\ \[Republic\]",
    'ch'  => 'ဆွစ်ဇလန်',
    'ci'  => 'အိုင်ဗရီကိုစ့်',
    'ck'  => "ကွတ်\ ကျွန်းစု",
    'cl'  => 'ချီလီ',
    'cm'  => 'ကင်မရွန်း',
    'cn'  => 'တရုတ်',
    'co'  => 'ကိုလံဘီယာ',
    'cp'  => "Clipperton\ Island",
    'cr'  => 'ကော့စ်တာရီကာ',
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'ကျူးဘား',
    'cv'  => "Cape\ Verde",
    'cx'  => "ခရစ်စမတ်\ ကျွန်း",
    'cy'  => 'ဆိုက်ပရက်စ်',
    'cz'  => "ချက်\ ပြည်ထောင်စု",
    'dd'  => "East\ Germany",
    'de'  => 'ဂျာမဏီ',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'ဒိန်းမတ်',
    'dm'  => 'ဒိုမီနီကာ',
    'do'  => 'ဒိုမီနီကန်',
    'dz'  => 'အယ်လ်ဂျီးရီးယား',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'အီကွေဒေါ',
    'ee'  => 'အက်စတိုးနီးယား',
    'eg'  => 'အီဂျစ်',
    'eh'  => "အနောက်ပိုင်း\ ဆာဟာရ",
    'er'  => 'Eritrea',
    'es'  => 'စပိန်',
    'et'  => 'အီသီယိုးပီးယား',
    'eu'  => 'ဥရောပသမဂ္ဂ',
    'fi'  => 'ဖင်လန်',
    'fj'  => 'ဖီဂျီ',
    'fk'  => "ဖောက်ကလန်\ ကျွန်းစု",
    'fm'  => 'Micronesia',
    'fo'  => "ဖာရိုး\ ကျွန်းစုများ",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'ပြင်သစ်',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabon',
    'gb'  => 'ယူနိုက်တက်ကင်းဒမ်း',
    'gd'  => 'Grenada',
    'ge'  => 'ဂျော်ဂျီယာ',
    'gf'  => "ပြင်သစ်\ ဂီယာနာ",
    'gg'  => 'Guernsey',
    'gh'  => 'ဂါနာ',
    'gi'  => 'ဂျီဘရော်လ်တာ',
    'gl'  => 'ဂရင်းလန်း',
    'gm'  => 'ဂန်ဘီရာ',
    'gn'  => 'ဂီရာနာ',
    'gp'  => 'Guadeloupe',
    'gq'  => "အီကွေတာ\ ဂီရာနာ",
    'gr'  => 'ဂရိ',
    'gs'  => "တောင်\ ဂျော်ဂျီယာ\ နှင့်\ တောင်\ ဆင်းဒဝစ်ဂျ်\ ကျွန်းစုများ",
    'gt'  => 'ဂွာတီမာလာ',
    'gu'  => 'ဂူအမ်',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => 'ဟောင်ကောင်',
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'ဟွန်ဒူးရပ်စ်',
    'hr'  => 'ခရိုအေးရှား',
    'ht'  => 'ဟေတီ',
    'hu'  => 'ဟန်ဂေရီ',
    'ic'  => "Canary\ Islands",
    'id'  => 'အင်ဒိုနီးရှား',
    'ie'  => 'အိုင်ယာလန်',
    'il'  => 'အစ္စရေး',
    'im'  => "Isle\ of\ Man",
    'in'  => 'အိန္ဒိယ',
    'io'  => "ဗြိတိသျှ\ အိန္ဒြိယ\ သမုဒ္ဒရာ\ ပိုင်နက်",
    'iq'  => 'အီရတ်',
    'ir'  => 'အီရန်',
    'is'  => 'အိုက်စလန်',
    'it'  => 'အီတလီ',
    'je'  => 'ဂျာစီ',
    'jm'  => 'ဂျမေနီကာ',
    'jo'  => 'ဂျော်ဒန်',
    'jp'  => 'ဂျပန်',
    'jt'  => "Johnston\ Island",
    'ke'  => 'ကင်ညာ',
    'kg'  => 'ခယ်ကစ်စတန်',
    'kh'  => 'ကမ္ဘောဒီးယား',
    'ki'  => 'Kiribati',
    'km'  => 'Comoros',
    'kn'  => "Saint\ Kitts\ and\ Nevis",
    'kp'  => 'မြောက်ကိုရီးယား',
    'kr'  => 'တောင်ကိုရီးယား',
    'kw'  => 'ကူဝိတ်',
    'ky'  => "ကေမန်\ ကျွန်းစု",
    'kz'  => 'ကာဇက်စတန်',
    'la'  => 'လာအို',
    'lb'  => 'လက်ဘနွန်',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => 'သီရိလင်္ကာ',
    'lr'  => 'လိုင်ဘေးရီးယား',
    'ls'  => 'Lesotho',
    'lt'  => 'လစ်သူယေးနီးယား',
    'lu'  => 'လူဇင်ဘတ်',
    'lv'  => 'လတ်ဗီးယား',
    'ly'  => 'Libya',
    'ma'  => 'မော်ရိုကို',
    'mc'  => 'မိုနကို',
    'md'  => 'Moldova',
    'me'  => 'မွန်တီနိဂရိုး',
    'mf'  => 'စိန့်မာတင်',
    'mg'  => 'မဒဂတ်စကာ',
    'mh'  => "မာရှယ်\ ကျွန်းစု",
    'mi'  => "Midway\ Islands",
    'mk'  => 'မာစီဒိုးနီးယား',
    'ml'  => 'မာလီ',
    'mm'  => 'မြန်မာ',
    'mn'  => 'မွန်ဂိုးလီးယား',
    'mo'  => 'မကာအို',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'မော်လဒိုက်',
    'mw'  => 'မာလာဝီ',
    'mx'  => 'မက္ကဆီကို',
    'my'  => 'မလေးရှား',
    'mz'  => 'မိုဇန်ဘစ်',
    'na'  => 'နမ်မီးဘီးယား',
    'nc'  => "နယူး\ ကယ်လီဒိုနီးယား",
    'ne'  => 'နိုင်ဂျာ',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'နိုင်ဂျီးရီးယား',
    'ni'  => 'နီကာရာဂွာ',
    'nl'  => 'နယ်သာလန်',
    'no'  => 'နော်ဝေ',
    'np'  => 'နီပေါ',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'နယူးဇီလန်',
    'om'  => 'အိုမန်',
    'pa'  => 'ပနားမား',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'ပီရူး',
    'pf'  => "ပြင်သစ်\ ပေါ်လီနေးရှား",
    'pg'  => 'ပါပူရာနယူးဂီနီ',
    'ph'  => 'ဖိလစ်ပိုင်',
    'pk'  => 'ပါကစ္စတန်',
    'pl'  => 'ပိုလန်',
    'pm'  => "Saint\ Pierre\ and\ Miquelon",
    'pn'  => "Pitcairn\ Islands",
    'pr'  => 'ပေါ်တူရီကို',
    'ps'  => "ပါလက်စတိုင်း\ ပိုင်နက်",
    'pt'  => 'ပေါ်တူဂီ',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'ပါရာဂွေး',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'ကာတာ',
    'qo'  => "Outlying\ Oceania",
    're'  => "R\Ã\©union",
    'ro'  => 'ရိုမေးနီးယား',
    'rs'  => 'ဆားဘီးယား',
    'ru'  => 'ရုရှ',
    'rw'  => 'ရဝန်ဒါ',
    'sa'  => 'ဆော်ဒီအာရေးဗီးယား',
    'sb'  => 'ဆော်လမွန်ကျွန်းစု',
    'sc'  => 'Seychelles',
    'sd'  => 'ဆူဒန်',
    'se'  => 'ဆွီဒင်',
    'sg'  => 'စင်္ကာပူ',
    'sh'  => "Saint\ Helena",
    'si'  => 'စလိုဗေးနီးယား',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'စလိုဗေးကီးယား',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'ဆီနီဂေါ',
    'so'  => 'ဆိုမာလီယာ',
    'sr'  => 'Suriname',
    'st'  => "S\Ã\£o\ Tom\Ã\©\ and\ Pr\Ã\­ncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'အယ်လ်ဆာဗေးဒိုး',
    'sy'  => 'ဆီးရီးယား',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'ချဒ်',
    'tf'  => "ပြင်သစ်\ တောင်ပိုင်း\ ပိုင်နက်များ",
    'tg'  => 'Togo',
    'th'  => 'ထိုင်း',
    'tj'  => 'တာဂျီကစ္စတန်',
    'tk'  => 'Tokelau',
    'tl'  => 'အရှေ့တီမော',
    'tm'  => 'Turkmenistan',
    'tn'  => 'တူနီးရှား',
    'to'  => 'တွန်ဂါ',
    'tr'  => 'တူရကီ',
    'tt'  => "Trinidad\ and\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'ထိုင်ဝမ်',
    'tz'  => 'တန်ဇန်နီးယား',
    'ua'  => 'ယူကရိန်း',
    'ug'  => 'ယူဂန္ဒာ',
    'um'  => "ယူနိုက်တက်စတိတ်\ အပြင်ထွက်\ နေသည့်\ သေးငယ်သောကျွန်းများ",
    'us'  => 'ယူနိုက်တက်စတိတ်',
    'uy'  => 'ဥရုဂွေး',
    'uz'  => 'ဥဘက်ကစ္စတန်',
    'va'  => 'ဗာတီကန်',
    'vc'  => "Saint\ Vincent\ and\ the\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'ဗင်နီဇွဲလား',
    'vg'  => "ဗြိတိသျှ\ ဗာဂျင်း\ ကျွန်းစု",
    'vi'  => "ယူအက်စ်\ ဗာဂျင်း\ ကျွန်းစု",
    'vn'  => 'ဗီယက်နမ်',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ and\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'ယီမင်',
    'yt'  => 'Mayotte',
    'za'  => 'တောင်အာဖရိက',
    'zm'  => 'ဇမ်ဘီယာ',
    'zw'  => 'ဇင်ဘာဘွေ',
    'zz'  => "မသိ\ သို့မဟုတ်\ မရှိ\ သော\ နေရာ",
);

%Locales::DB::Territory::my::name_to_code = (
    'albania'                                                                                                                                             => 'al',
    'andorra'                                                                                                                                             => 'ad',
    'antiguaandbarbuda'                                                                                                                                   => 'ag',
    'aruba'                                                                                                                                               => 'aw',
    'ascensionisland'                                                                                                                                     => 'ac',
    'barbados'                                                                                                                                            => 'bb',
    'benin'                                                                                                                                               => 'bj',
    'bouvetisland'                                                                                                                                        => 'bv',
    'britishantarcticterritory'                                                                                                                           => 'bq',
    'burkinafaso'                                                                                                                                         => 'bf',
    'burundi'                                                                                                                                             => 'bi',
    'canaryislands'                                                                                                                                       => 'ic',
    'cantonandenderburyislands'                                                                                                                           => 'ct',
    'capeverde'                                                                                                                                           => 'cv',
    'ceutaandmelilla'                                                                                                                                     => 'ea',
    'channelislands'                                                                                                                                      => 830,
    'clippertonisland'                                                                                                                                    => 'cp',
    'comoros'                                                                                                                                             => 'km',
    'congodrc'                                                                                                                                            => 'cd',
    'congorepublic'                                                                                                                                       => 'cg',
    'czechoslovakia'                                                                                                                                      => 200,
    'diegogarcia'                                                                                                                                         => 'dg',
    'djibouti'                                                                                                                                            => 'dj',
    'dronningmaudland'                                                                                                                                    => 'nq',
    'eastgermany'                                                                                                                                         => 'dd',
    'eritrea'                                                                                                                                             => 'er',
    'frenchsouthernandantarcticterritories'                                                                                                               => 'fq',
    'gabon'                                                                                                                                               => 'ga',
    'grenada'                                                                                                                                             => 'gd',
    'guadeloupe'                                                                                                                                          => 'gp',
    'guernsey'                                                                                                                                            => 'gg',
    'guineabissau'                                                                                                                                        => 'gw',
    'guyana'                                                                                                                                              => 'gy',
    'heardislandandmcdonaldislands'                                                                                                                       => 'hm',
    'isleofman'                                                                                                                                           => 'im',
    'johnstonisland'                                                                                                                                      => 'jt',
    'kiribati'                                                                                                                                            => 'ki',
    'lesotho'                                                                                                                                             => 'ls',
    'libya'                                                                                                                                               => 'ly',
    'liechtenstein'                                                                                                                                       => 'li',
    'malta'                                                                                                                                               => 'mt',
    'martinique'                                                                                                                                          => 'mq',
    'mauritania'                                                                                                                                          => 'mr',
    'mauritius'                                                                                                                                           => 'mu',
    'mayotte'                                                                                                                                             => 'yt',
    'melanesia'                                                                                                                                           => '054',
    'metropolitanfrance'                                                                                                                                  => 'fx',
    'micronesia'                                                                                                                                          => 'fm',
    'micronesianregion'                                                                                                                                   => '057',
    'midwayislands'                                                                                                                                       => 'mi',
    'moldova'                                                                                                                                             => 'md',
    'montserrat'                                                                                                                                          => 'ms',
    'nauru'                                                                                                                                               => 'nr',
    'netherlandsantilles'                                                                                                                                 => 'an',
    'neutralzone'                                                                                                                                         => 'nt',
    'niue'                                                                                                                                                => 'nu',
    'norfolkisland'                                                                                                                                       => 'nf',
    'northernmarianaislands'                                                                                                                              => 'mp',
    'northvietnam'                                                                                                                                        => 'vd',
    'outlyingoceania'                                                                                                                                     => 'qo',
    'pacificislandstrustterritory'                                                                                                                        => 'pc',
    'palau'                                                                                                                                               => 'pw',
    'panamacanalzone'                                                                                                                                     => 'pz',
    "people\â\\sdemocraticrepublicofyemen"                                                                                                           => 'yd',
    'pitcairnislands'                                                                                                                                     => 'pn',
    'polynesia'                                                                                                                                           => '061',
    "r\Ã\©union"                                                                                                                                        => 're',
    "saintbarth\Ã\©lemy"                                                                                                                                => 'bl',
    'sainthelena'                                                                                                                                         => 'sh',
    'saintkittsandnevis'                                                                                                                                  => 'kn',
    'saintlucia'                                                                                                                                          => 'lc',
    'saintpierreandmiquelon'                                                                                                                              => 'pm',
    'saintvincentandthegrenadines'                                                                                                                        => 'vc',
    'samoa'                                                                                                                                               => 'ws',
    'sanmarino'                                                                                                                                           => 'sm',
    'serbiaandmontenegro'                                                                                                                                 => 'cs',
    'seychelles'                                                                                                                                          => 'sc',
    'sierraleone'                                                                                                                                         => 'sl',
    'suriname'                                                                                                                                            => 'sr',
    'svalbardandjanmayen'                                                                                                                                 => 'sj',
    'swaziland'                                                                                                                                           => 'sz',
    "s\Ã\£otom\Ã\©andpr\Ã\­ncipe"                                                                                                                   => 'st',
    'togo'                                                                                                                                                => 'tg',
    'tokelau'                                                                                                                                             => 'tk',
    'trinidadandtobago'                                                                                                                                   => 'tt',
    'tristandacunha'                                                                                                                                      => 'ta',
    'turkmenistan'                                                                                                                                        => 'tm',
    'turksandcaicosislands'                                                                                                                               => 'tc',
    'tuvalu'                                                                                                                                              => 'tv',
    "u\.s\.miscellaneouspacificislands"                                                                                                                   => 'pu',
    'unionofsovietsocialistrepublics'                                                                                                                     => 'su',
    'vanuatu'                                                                                                                                             => 'vu',
    'wakeisland'                                                                                                                                          => 'wk',
    'wallisandfutuna'                                                                                                                                     => 'wf',
    "\Ã\landislands"                                                                                                                                   => 'ax',
    'ကင်ညာ'                                                                                                                                     => 'ke',
    'ကင်မရွန်း'                                                                                                                         => 'cm',
    'ကနေဒါ'                                                                                                                                     => 'ca',
    'ကမ္ဘာ'                                                                                                                                     => '001',
    'ကမ္ဘောဒီးယား'                                                                                                                => 'kh',
    'ကာဇက်စတန်'                                                                                                                         => 'kz',
    'ကာတာ'                                                                                                                                        => 'qa',
    'ကာရီဘီယံ'                                                                                                                            => '029',
    'ကိုကိုးကျွန်းစု'                                                                                                       => 'cc',
    'ကိုလံဘီယာ'                                                                                                                         => 'co',
    'ကူဝိတ်'                                                                                                                                  => 'kw',
    'ကေမန်ကျွန်းစု'                                                                                                             => 'ky',
    'ကော့စ်တာရီကာ'                                                                                                                => 'cr',
    'ကျူးဘား'                                                                                                                               => 'cu',
    'ကွတ်ကျွန်းစု'                                                                                                                => 'ck',
    'ခယ်ကစ်စတန်'                                                                                                                      => 'kg',
    'ခရစ်စမတ်ကျွန်း'                                                                                                          => 'cx',
    'ခရိုအေးရှား'                                                                                                                   => 'hr',
    'ချက်ပြည်ထောင်စု'                                                                                                       => 'cz',
    'ချဒ်'                                                                                                                                        => 'td',
    'ချီလီ'                                                                                                                                     => 'cl',
    'ဂန်ဘီရာ'                                                                                                                               => 'gm',
    'ဂရင်းလန်း'                                                                                                                         => 'gl',
    'ဂရိ'                                                                                                                                           => 'gr',
    'ဂါနာ'                                                                                                                                        => 'gh',
    'ဂီရာနာ'                                                                                                                                  => 'gn',
    'ဂူအမ်'                                                                                                                                     => 'gu',
    'ဂျပန်'                                                                                                                                     => 'jp',
    'ဂျမေနီကာ'                                                                                                                            => 'jm',
    'ဂျာစီ'                                                                                                                                     => 'je',
    'ဂျာမဏီ'                                                                                                                                  => 'de',
    'ဂျီဘရော်လ်တာ'                                                                                                                => 'gi',
    'ဂျော်ဂျီယာ'                                                                                                                      => 'ge',
    'ဂျော်ဒန်'                                                                                                                            => 'jo',
    'ဂွာတီမာလာ'                                                                                                                         => 'gt',
    'စင်္ကာပူ'                                                                                                                            => 'sg',
    'စပိန်'                                                                                                                                     => 'es',
    'စလိုဗေးကီးယား'                                                                                                             => 'sk',
    'စလိုဗေးနီးယား'                                                                                                             => 'si',
    'စိန့်မာတင်'                                                                                                                      => 'mf',
    'ဆားဘီးယား'                                                                                                                         => 'rs',
    'ဆိုက်ပရက်စ်'                                                                                                                   => 'cy',
    'ဆိုမာလီယာ'                                                                                                                         => 'so',
    'ဆီနီဂေါ'                                                                                                                               => 'sn',
    'ဆီးရီးယား'                                                                                                                         => 'sy',
    'ဆူဒန်'                                                                                                                                     => 'sd',
    'ဆော်ဒီအာရေးဗီးယား'                                                                                                 => 'sa',
    'ဆော်လမွန်ကျွန်းစု'                                                                                                 => 'sb',
    'ဆွစ်ဇလန်'                                                                                                                            => 'ch',
    'ဆွီဒင်'                                                                                                                                  => 'se',
    'ဇင်ဘာဘွေ'                                                                                                                            => 'zw',
    'ဇမ်ဘီယာ'                                                                                                                               => 'zm',
    'တန်ဇန်နီးယား'                                                                                                                => 'tz',
    'တရုတ်'                                                                                                                                     => 'cn',
    'တာဂျီကစ္စတန်'                                                                                                                => 'tj',
    'တူနီးရှား'                                                                                                                         => 'tn',
    'တူရကီ'                                                                                                                                     => 'tr',
    'တောင်ကိုရီးယား'                                                                                                          => 'kr',
    'တောင်ဂျော်ဂျီယာနှင့်တောင်ဆင်းဒဝစ်ဂျ်ကျွန်းစုများ'    => 'gs',
    'တောင်ပိုင်းအာဖရိက'                                                                                                 => '018',
    'တောင်ပိုင်းအာရှ'                                                                                                       => '034',
    'တောင်ပိုင်းဥရောပ'                                                                                                    => '039',
    'တောင်အမေရိက'                                                                                                                   => '005',
    'တောင်အလယ်အာရှ'                                                                                                             => '062',
    'တောင်အာဖရိက'                                                                                                                   => 'za',
    'တွန်ဂါ'                                                                                                                                  => 'to',
    'ထိုင်ဝမ်'                                                                                                                            => 'tw',
    'ထိုင်း'                                                                                                                                  => 'th',
    'ဒိန်းမတ်'                                                                                                                            => 'dk',
    'ဒိုမီနီကန်'                                                                                                                      => 'do',
    'ဒိုမီနီကာ'                                                                                                                         => 'dm',
    'နမ်မီးဘီးယား'                                                                                                                => 'na',
    'နယူးကယ်လီဒိုနီးယား'                                                                                              => 'nc',
    'နယူးဇီလန်'                                                                                                                         => 'nz',
    'နယ်သာလန်'                                                                                                                            => 'nl',
    'နိုင်ဂျာ'                                                                                                                            => 'ne',
    'နိုင်ဂျီးရီးယား'                                                                                                       => 'ng',
    'နီကာရာဂွာ'                                                                                                                         => 'ni',
    'နီပေါ'                                                                                                                                     => 'np',
    'နော်ဝေ'                                                                                                                                  => 'no',
    'ပနားမား'                                                                                                                               => 'pa',
    'ပါကစ္စတန်'                                                                                                                         => 'pk',
    'ပါပူရာနယူးဂီနီ'                                                                                                          => 'pg',
    'ပါရာဂွေး'                                                                                                                            => 'py',
    'ပါလက်စတိုင်းပိုင်နက်'                                                                                        => 'ps',
    'ပိုလန်'                                                                                                                                  => 'pl',
    'ပီရူး'                                                                                                                                     => 'pe',
    'ပေါ်တူဂီ'                                                                                                                            => 'pt',
    'ပေါ်တူရီကို'                                                                                                                   => 'pr',
    'ပြင်သစ်'                                                                                                                               => 'fr',
    'ပြင်သစ်ဂီယာနာ'                                                                                                             => 'gf',
    'ပြင်သစ်တောင်ပိုင်းပိုင်နက်များ'                                                          => 'tf',
    'ပြင်သစ်ပေါ်လီနေးရှား'                                                                                        => 'pf',
    'ဖင်လန်'                                                                                                                                  => 'fi',
    'ဖာရိုးကျွန်းစုများ'                                                                                              => 'fo',
    'ဖိလစ်ပိုင်'                                                                                                                      => 'ph',
    'ဖီဂျီ'                                                                                                                                     => 'fj',
    'ဖောက်ကလန်ကျွန်းစု'                                                                                                 => 'fk',
    'ဗင်နီဇွဲလား'                                                                                                                   => 've',
    'ဗာတီကန်'                                                                                                                               => 'va',
    'ဗီယက်နမ်'                                                                                                                            => 'vn',
    'ဗြိတိသျှဗာဂျင်းကျွန်းစု'                                                                               => 'vg',
    'ဗြိတိသျှအိန္ဒြိယသမုဒ္ဒရာပိုင်နက်'                                                    => 'io',
    'ဘင်္ဂလားဒေ့ရှ်'                                                                                                          => 'bd',
    'ဘယ်လ်ဂျီယမ်'                                                                                                                   => 'be',
    'ဘရာဇီး'                                                                                                                                  => 'br',
    'ဘရူနိုင်း'                                                                                                                         => 'bn',
    'ဘဟားမား'                                                                                                                               => 'bs',
    'ဘာမူဒါ'                                                                                                                                  => 'bm',
    'ဘာရိန်း'                                                                                                                               => 'bh',
    'ဘိုလီးဘီးယား'                                                                                                                => 'bo',
    'ဘီလာရုစ်'                                                                                                                            => 'by',
    'ဘူဂေးရီးယား'                                                                                                                   => 'bg',
    'ဘူတန်'                                                                                                                                     => 'bt',
    'ဘေလီဇ်'                                                                                                                                  => 'bz',
    'ဘော့စနီးယားနှင့်ဟာဇီဂိုဘီးနား'                                                             => 'ba',
    'ဘော့စ်ဝါနာ'                                                                                                                      => 'bw',
    'မကာအို'                                                                                                                                  => 'mo',
    'မက္ကဆီကို'                                                                                                                         => 'mx',
    'မဒဂတ်စကာ'                                                                                                                            => 'mg',
    'မလေးရှား'                                                                                                                            => 'my',
    'မသိသို့မဟုတ်မရှိသောနေရာ'                                                                               => 'zz',
    'မာစီဒိုးနီးယား'                                                                                                          => 'mk',
    'မာရှယ်ကျွန်းစု'                                                                                                          => 'mh',
    'မာလာဝီ'                                                                                                                                  => 'mw',
    'မာလီ'                                                                                                                                        => 'ml',
    'မိုဇန်ဘစ်'                                                                                                                         => 'mz',
    'မိုနကို'                                                                                                                               => 'mc',
    'မော်ရိုကို'                                                                                                                      => 'ma',
    'မော်လဒိုက်'                                                                                                                      => 'mv',
    'မြန်မာ'                                                                                                                                  => 'mm',
    'မြောက်ကိုရီးယား'                                                                                                       => 'kp',
    'မြောက်ပိုင်းအမေရိက'                                                                                              => '021',
    'မြောက်ပိုင်းအာဖရိက'                                                                                              => '015',
    'မြောက်ပိုင်းဥရောပ'                                                                                                 => 154,
    'မြောက်အမေရိက'                                                                                                                => '003',
    'မွန်ဂိုးလီးယား'                                                                                                          => 'mn',
    'မွန်တီနိဂရိုး'                                                                                                             => 'me',
    'ယီမင်'                                                                                                                                     => 'ye',
    'ယူကရိန်း'                                                                                                                            => 'ua',
    'ယူဂန္ဒာ'                                                                                                                               => 'ug',
    'ယူနိုက်တက်ကင်းဒမ်း'                                                                                              => 'gb',
    'ယူနိုက်တက်စတိတ်'                                                                                                       => 'us',
    'ယူနိုက်တက်စတိတ်အပြင်ထွက်နေသည့်သေးငယ်သောကျွန်းများ' => 'um',
    'ယူအက်စ်ဗာဂျင်းကျွန်းစု'                                                                                  => 'vi',
    'ယူအေအီး'                                                                                                                               => 'ae',
    'ရဝန်ဒါ'                                                                                                                                  => 'rw',
    'ရိုမေးနီးယား'                                                                                                                => 'ro',
    'ရုရှ'                                                                                                                                        => 'ru',
    'လက်တင်အမေရိကနှင့်ကာရီဘီယန်'                                                                      => 419,
    'လက်ဘနွန်'                                                                                                                            => 'lb',
    'လစ်သူယေးနီးယား'                                                                                                          => 'lt',
    'လတ်ဗီးယား'                                                                                                                         => 'lv',
    'လာအို'                                                                                                                                     => 'la',
    'လိုင်ဘေးရီးယား'                                                                                                          => 'lr',
    'လူဇင်ဘတ်'                                                                                                                            => 'lu',
    'လွတ်လပ်သောပြည်ထောင်စုများ၏ဓနသဟာယအဖွဲ့'                                     => 172,
    'သမုဒ္ဒရာဒေသ'                                                                                                                   => '009',
    'သီရိလင်္ကာ'                                                                                                                      => 'lk',
    'ဟန်ဂေရီ'                                                                                                                               => 'hu',
    'ဟေတီ'                                                                                                                                        => 'ht',
    'ဟောင်ကောင်'                                                                                                                      => 'hk',
    'ဟွန်ဒူးရပ်စ်'                                                                                                                => 'hn',
    'အက်စတိုးနီးယား'                                                                                                          => 'ee',
    'အင်ဂိုလာ'                                                                                                                            => 'ao',
    'အင်ဒိုနီးရှား'                                                                                                             => 'id',
    'အစ္စရေး'                                                                                                                               => 'il',
    'အဇာဘိုင်ဂျန်'                                                                                                                => 'az',
    'အနောက်ပိုင်းဆာဟာရ'                                                                                                 => 'eh',
    'အနောက်ပိုင်းဥရောပ'                                                                                                 => 155,
    'အနောက်အာဖရိက'                                                                                                                => '011',
    'အနောက်အာရှ'                                                                                                                      => 145,
    'အန္တာတိက'                                                                                                                            => 'aq',
    'အန်ကွီလာ'                                                                                                                            => 'ai',
    'အမေရိကန်စမိုအ'                                                                                                             => 'as',
    'အမေရိကများ'                                                                                                                      => '019',
    'အယ်လ်ဂျီးရီးယား'                                                                                                       => 'dz',
    'အယ်လ်ဆာဗေးဒိုး'                                                                                                          => 'sv',
    'အရှေ့တီမော'                                                                                                                      => 'tl',
    'အရှေ့ပိုင်းအာဖရိက'                                                                                                 => '014',
    'အရှေ့ပိုင်းအာရှ'                                                                                                       => '030',
    'အရှေ့ပိုင်းဥရောပ'                                                                                                    => 151,
    'အလယ်ပိုင်းအမေရိက'                                                                                                    => '013',
    'အလယ်ပိုင်းအာဖရိက'                                                                                                    => '017',
    'အလယ်ပိုင်းအာဖရိကပြည်ထောင်စု'                                                                   => 'cf',
    'အလယ်အာရှ'                                                                                                                            => 143,
    'အာဂျင်တီးနား'                                                                                                                => 'ar',
    'အာဖဂန်နစ္စတန်'                                                                                                             => 'af',
    'အာဖရိက'                                                                                                                                  => '002',
    'အာမေနီးယား'                                                                                                                      => 'am',
    'အာရှ'                                                                                                                                        => 142,
    'အိန္ဒိယ'                                                                                                                               => 'in',
    'အိုက်စလန်'                                                                                                                         => 'is',
    'အိုင်ဗရီကိုစ့်'                                                                                                          => 'ci',
    'အိုင်ယာလန်'                                                                                                                      => 'ie',
    'အိုမန်'                                                                                                                                  => 'om',
    'အီကွေတာဂီရာနာ'                                                                                                             => 'gq',
    'အီကွေဒေါ'                                                                                                                            => 'ec',
    'အီဂျစ်'                                                                                                                                  => 'eg',
    'အီတလီ'                                                                                                                                     => 'it',
    'အီရတ်'                                                                                                                                     => 'iq',
    'အီရန်'                                                                                                                                     => 'ir',
    'အီသီယိုးပီးယား'                                                                                                          => 'et',
    'အ‌ရှေ့တောင်ပိုင်းအာရှ'                                                                                     => '035',
    'ဥဘက်ကစ္စတန်'                                                                                                                   => 'uz',
    'ဥရုဂွေး'                                                                                                                               => 'uy',
    'ဥရောပ'                                                                                                                                     => 150,
    'ဥရောပသမဂ္ဂ'                                                                                                                      => 'eu',
    'ဩစတြီးယား'                                                                                                                         => 'at',
    'ဩစတြေးလျှနှင့်နယူးဇီလန်'                                                                               => '053',
    'ဩစတြေးလျှား'                                                                                                                   => 'au',
);

1;

