# CONTRIBUTING

Thank you for considering contributing to {{ $dist }}.
This file contains instructions that will help you work with
the source code.

## Repository branches structure

The two main branches of this repository are:

* **master**

The main development branch. This branch has to
be processed by Dist::Zilla to generate the
code as it will appear in the CPAN distribution. See the
next section for more details.

* **releases**

Contains the code as it appears on CPAN. Each official
release is also tagged with its version.

## Working on the master branch

The distribution is managed with [Dist::Zilla][distzilla].
This means than many of the usual files you might expect
are not in the repository, but are generated at release time.

However, you can run tests directly using the 'prove' tool:

``` bash
$ prove -l
$ prove -lv t/some_test_file.t
$ prove -lvr t/
```

In most cases, 'prove' is entirely sufficient for you to test any
patches you have.

You may need to satisfy some dependencies. The easiest way to satisfy
dependencies is to install the last release -- this is available at
https://metacpan.org/release/{{ $dist }}.

If you use cpanminus, you can do it without downloading the tarball first:

``` bash
$ cpanm --reinstall --installdeps --with-recommends {{ $dist =~ s/-/::/gr }}
```

Dist::Zilla is a very powerful authoring tool, but requires a number of
author-specific plugins. If you would like to use it for contributing,
install it from CPAN, then run one of the following commands, depending on
your CPAN client:

``` bash
$ cpan `dzil authordeps --missing`
$ dzil authordeps --missing | cpanm
```

You should then also install any additional requirements not needed by the
dzil build but may be needed by tests or other development:

``` bash
# cpan `dzil listdeps --author --missing`
$ dzil listdeps --author --missing | cpanm
```

You can also do this via cpanm directly:

``` bash
$ cpanm --reinstall --installdeps --with-develop --with-recommends {{ $dist =~ s/-/::/gr }}
```

Once installed, here are some dzil commands you might try:

``` bash
$ dzil build
$ dzil test
$ dzil test --release
$ dzil xtest
$ dzil listdeps --json
$ dzil build --notgz
```


## This Is Complicated. Is There an Easier Way?

Actually, yes there is. You can also work directly on the `releases` branch,
which corresponds to the code is generated by Dist::Zilla and
correspond to what is uploaded to CPAN.

It won't contain any of the changes brought to the codebase since the last
CPAN release, but for a small patch that shouldn't be a problem.

## Sending Patches

The code for this distribution is hosted on [GitHub][repository].

You can submit bug reports via the [repository's issue track][bugtracker].

You can also submit code changes by forking the repository, pushing your code
changes to your clone, and then submitting a pull request. Detailed
instructions for doing that is available here:

* https://help.github.com/
* https://help.github.com/articles/creating-a-pull-request

[distzilla]:  http://dzil.org/.
[repository]: https://github.com/perl5-dbi/DBD-Oracle/
[bugtracker]: https://github.com/perl5-dbi/DBD-Oracle/issues

